/*
 * QrfeQwt.cpp
 *
 *  Created on: 06.05.2011
 *      Author: stefan.detter
 */

#include "../inc/QrfeQwt.h"

#include <QObject>
#include <QString>
#include <QStringList>
#include <QFileDialog>
#include <QImageWriter>

#include "../inc/qwt_plot.h"
#include "../inc/qwt_plot_renderer.h"

bool QrfeQwt::savePlotToFile(QwtPlot* plot, QWidget * parent, const QString & caption, const QString & dir, QString & outputFileName )
{
    const QList<QByteArray> imageFormats =
        QImageWriter::supportedImageFormats();

    QStringList filter;
    filter += parent->tr("PDF Documents (*.pdf)");
#ifndef QWT_NO_SVG
    filter += parent->tr("SVG Documents (*.svg)");
#endif
    filter += parent->tr("Postscript Documents (*.ps)");

    if ( imageFormats.size() > 0 )
    {
        QString imageFilter(parent->tr("Images ("));
        for ( int i = 0; i < imageFormats.size(); i++ )
        {
            if ( i > 0 )
                imageFilter += " ";
            imageFilter += "*.";
            imageFilter += imageFormats[i];
        }
        imageFilter += ")";

        filter += imageFilter;
    }

    QString fileName = QFileDialog::getSaveFileName(parent, caption, dir, filter.join(";;"));
    if ( !fileName.isEmpty() )
    {
        QwtPlotRenderer renderer;
        renderer.renderDocument(plot, fileName, QSizeF(300, 200), 85);
    }
    else
    	return false;

    outputFileName = fileName;

    return true;
}
